<?php
include 'db.php';

// Get JSON input from AJAX request
$data = json_decode(file_get_contents('php://input'), true);

// Check if data is received 
if ($data && is_array($data)) {
    $response = ['success' => false, 'message' => 'Error inserting or updating data.'];

    // Loop through the data array
    foreach ($data as $item) {
        // Sanitize inputs to prevent SQL injection
        $categoryid = $item['categoryid'];
        $productid = $item['productid'];
        $position = $item['position'];
        $mode = $item['mode'];

        // SQL query to check if the record already exists
        $checkQuery = "SELECT * FROM catagorydata WHERE categoryid = $categoryid AND productid = $productid";
        $checkResult = mysqli_query($connection, $checkQuery);

        if ($checkResult && mysqli_num_rows($checkResult) > 0) {
            // Record exists, perform an update
            $sql = "UPDATE catagorydata 
                    SET position = $position, mode = $mode 
                    WHERE categoryid = $categoryid AND productid = $productid";
        } else {
            // Record doesn't exist, perform an insert
            $sql = "INSERT INTO catagorydata (categoryid, productid, position, mode, delete_status) 
                    VALUES ($categoryid, $productid, $position, $mode, 0)";
        }

        // Log the SQL query for debugging
        error_log("SQL Query: " . $sql);

        // Execute the query
        if (mysqli_query($connection, $sql)) {
            $response['success'] = true;
        } else {
            // Capture the actual error message from MySQL
            $response['message'] = 'Failed to insert or update data for product ID ' . $productid . '. Error: ' . mysqli_error($connection);
            break; // Stop if any insertion or update fails
        }
    }

    // Return the response as JSON
    echo json_encode($response);
} else {
    // Invalid or missing data
    echo json_encode(['success' => false, 'message' => 'Invalid input data.']);
}
?>
